/*
 * Decompiled with CFR 0.152.
 */
package dev.codenmore.tilegame.gfx;

import dev.codenmore.tilegame.Handler;
import dev.codenmore.tilegame.entities.Entity;

public class GameCamera {
    private Handler handler;
    private float xOffset;
    private float yOffset;

    public GameCamera(Handler handler, float xOffset, float yOffset) {
        this.handler = handler;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public void checkBlankSpace() {
        if (this.xOffset < 0.0f) {
            this.xOffset = 0.0f;
        } else if (this.xOffset > (float)(this.handler.getWorld().getWidth() * 64 - this.handler.getWidth())) {
            this.xOffset = this.handler.getWorld().getWidth() * 64 - this.handler.getWidth();
        }
        if (this.yOffset < 0.0f) {
            this.yOffset = 0.0f;
        } else if (this.yOffset > (float)(this.handler.getWorld().getHeight() * 64 - this.handler.getHeight())) {
            this.yOffset = this.handler.getWorld().getHeight() * 64 - this.handler.getHeight();
        }
    }

    public void centerOnEntity(Entity e) {
        this.xOffset = e.getX() - (float)(this.handler.getWidth() / 2) + (float)(e.getWidth() / 2);
        this.yOffset = e.getY() - (float)(this.handler.getHeight() / 2) + (float)(e.getHeight() / 2);
        this.checkBlankSpace();
    }

    public void move(float xAmt, float yAmt) {
        this.xOffset += xAmt;
        this.yOffset += yAmt;
        this.checkBlankSpace();
    }

    public float getxOffset() {
        return this.xOffset;
    }

    public void setxOffset(float xOffset) {
        this.xOffset = xOffset;
    }

    public float getyOffset() {
        return this.yOffset;
    }

    public void setyOffset(float yOffset) {
        this.yOffset = yOffset;
    }
}

